**************************************************************************
** Program Name :   VFXGENDBC.PRG
**************************************************************************
PROCEDURE VfxGenDBC
LPARAMETERS cOutFile, lSkipDisplay

LOCAL lcFileName, loError AS EXCEPTION, llGenDbcRes

lcFileName = SYS(2015)
llGenDbcRes = .T.
g_cSetTalk = SET("TALK")
IF g_cSetTalk = "ON"
	SET TALK OFF
ENDIF
g_lskipdisplay 	 = IIF(VARTYPE(lSkipDisplay) # "L", .F., lSkipDisplay)
g_cFullPath 	 = SET("FULLPATH")				&& To restore old FULLPATH setting
g_cSetDeleted 	 = SET("DELETED")				&& To restore SET DELETED later
g_cSetStatusBar = SET("STATUS BAR")				&& To restore STATUS bar
g_cStatusText 	 = SYS(2001, "MESSAGE", 1)		&& To restore text that may be on it
g_nMax 			 = 7								&& For status line information
g_nCurrentStat 	 = 1								&& For status line information
g_cFilterExp 	 = ""                         	&& For Non-Supported Filter Info
DIMENSION g_aProcs[1]
SET DELETED ON
SET FULLPATH ON
IF m.g_cSetStatusBar = "OFF"
	SET STATUS BAR ON
ENDIF
g_cCompat = SET("COMPATIBLE")
IF m.g_cCompat = "ON"
	SET COMPATIBLE OFF
ENDIF

**************************************************************************
** Constants
**************************************************************************
#DEFINE CRLF 					CHR(13) + CHR(10)
#DEFINE DBCS_LOC 				"81 82 86 88"

**************************************************************************
** Error Messages
**************************************************************************
#DEFINE NO_DATABASE_IN_USE_LOC	"No Database is in use. " + ;
	"This program must have a database " + ;
	"available."
#DEFINE INVALID_PARAMETERS_LOC	"Invalid Parameters..." + CRLF + ;
	"An output file must be specified." + CRLF + ;
	'ie: DO GENDBC WITH "filename.prg"'
#DEFINE INVALID_DESTINATION_LOC	"Invalid Destination File "
#DEFINE NO_TEMP_FILE_LOC		"Could not create temporary file: "
#DEFINE NO_OUTPUT_WRITTEN_LOC   "Could not create or write to output file"
#DEFINE ERROR_TITLE_LOC			"Aborting GenDBC..."
#DEFINE UNRECOVERABLE_LOC		"Unrecoverable Error: "
#DEFINE AT_LINE_LOC				" At Line: "
#DEFINE NO_FIND_LOC				"Could not set RI Information."
#DEFINE NO_FILE_FOUND_LOC		"Warning! No Procedure File Found!"
#DEFINE GETFILE_GEN_LOC			"Generate..."
#DEFINE NOT_SUPPORTED_LOC		"Filters on PRIMARY keys are not supported at this time. " + ;
	"A comment will be added to your output file specifying the filters."
#DEFINE NS_COMMENT_LOC			"****** These filters need to be added manually ******"
#DEFINE WARNING_TITLE_LOC		"GenDBC Warning..."

**************************************************************************
** Comments And Other Information
**************************************************************************
#DEFINE MESSAGE_START_LOC		"Creating database..."
#DEFINE MESSAGE_DONE_LOC		"Finished."
#DEFINE MESSAGE_MAKETABLE_LOC 	"Creating table "
#DEFINE MESSAGE_MAKEVIEW_LOC	"Creating view "
#DEFINE MESSAGE_MAKECONN_LOC	"Creating connection "
#DEFINE MESSAGE_MAKERELATION_LOC	"Creating persistent relations..."
#DEFINE MESSAGE_MAKERI_LOC		"Creating relational integrity rules..."
#DEFINE MESSAGE_END_LOC			"..."
#DEFINE BEGIN_RELATION_LOC		"*************** Begin Relations Setup **************"
#DEFINE BEGIN_TABLE_LOC			"Table setup for "
#DEFINE BEGIN_INDEX_LOC			"Create each index for "
#DEFINE BEGIN_PROP_LOC			"Change properties for "
#DEFINE BEGIN_VIEW_LOC			"View setup for "
#DEFINE BEGIN_PROC_LOC			"Procedure Re-Creation"
#DEFINE BEGIN_CONNECTIONS_LOC	"Connection Definitions"
#DEFINE BEGIN_RI_LOC			"Referential Integrity Setup"
#DEFINE OPEN_DATABASE_LOC		"Select Database..."
#DEFINE SAVE_PRG_NAME_LOC		"Enter output program name..."
#DEFINE NO_MODIFY_LOC			"*** WARNING *** DO NOT MODIFY THIS FILE IN ANY WAY! *** WARNING ***"
#DEFINE TABLE_NAME_LOC			"*        Table Name: "
#DEFINE PRIMARY_KEY_LOC			"*       Primary Key: "
#DEFINE FILTER_EXP_LOC			"* Filter Expression: "
#DEFINE HEADING_1_LOC			"* *********************************************************" + CRLF + ;
	"* *" + CRLF
#DEFINE HEADING_2_LOC			"* *" + CRLF + ;
	"* *********************************************************" + CRLF + ;
	"* *" + CRLF + ;
	"* * Description:" + CRLF + ;
	"* * This program was automatically generated by GENDBC" + CRLF + ;
	"* * Version 2.26.67" + CRLF + ;
	"* *" + CRLF + ;
	"* *********************************************************" + CRLF

* Make sure a database is open
IF EMPTY(DBC())
	RETURN .F.
ENDIF

* Set global variable to the database name and format it
g_cDatabase = DBC()
IF RAT("\", m.g_cDatabase) > 0
	g_cDatabase = SUBSTR(m.g_cDatabase, RAT("\", m.g_cDatabase) + 1)
ENDIF

* Get the fullpath of database
g_cFullDatabase = DBC()

* Check for valid parameters
IF PARAMETERS() < 1 OR TYPE("cOutFile") # "C" OR EMPTY(cOutFile)
	RETURN .F.
ENDIF

* Check for proper extensions or add one if none specified
IF RAT(".PRG", m.cOutFile) = 0 AND RAT(".", m.cOutFile) = 0
	cOutFile = m.cOutFile + ".PRG"
ENDIF

TRY
* Make sure the output file is valid
	hFile = FCREATE(m.cOutFile)
	IF m.hFile <= 0
		FatalAlert(INVALID_DESTINATION_LOC + m.cOutFile, .F.)
	ENDIF

	FCLOSE(m.hFile)
	ERASE (m.cOutFile)
* Remember all our tables that are open for this database
	g_nTotal_Tables_Used = AUSED(g_aAlias_Used)
	IF m.g_nTotal_Tables_Used > 0
		DIMENSION m.g_aTables_Used(m.g_nTotal_Tables_Used)

* Get Real Names of tables opened
		FOR m.nLoop = 1 TO m.g_nTotal_Tables_Used
			g_aTables_Used(m.nLoop) = DBF(g_aAlias_Used(m.nLoop, 1))
		ENDFOR
	ENDIF
* Get number of tables contained in database
	nTotal_Tables = ADBOBJECTS(aAll_Tables, "Table")
	g_nMax = m.g_nMax + m.nTotal_Tables
	Stat_Message()

* Get number of views contained in database
	nTotal_Views = ADBOBJECTS(aAll_Views, "View")
	
	IF nTotal_Views > 0	&& V&U MS 2013-03-12
		* {V&U VM 2013-02-26
		* doubling the array to make room for 2nd column make
		dimension aAll_Views(nTotal_Views * 2)
		
		* move items
		FOR lnI = 2 TO nTotal_Views * 2 STEP 2
			AINS(aAll_Views, lnI)
		ENDFOR 

		* switch to 2 column
		dimension aAll_Views(nTotal_Views, 2)

		* fill comment to 2 column
		FOR lnI = 1 To nTotal_Views
			aAll_Views(lnI, 2) = val(DBGetProp(aAll_Views(lnI,1),"view","comment"))
		EndFor

		* sort by comment
		ASORT(aAll_Views, 2, nTotal_Views, 0, 1)
		* }V&U VM 2013-02-26
	ENDIF 
	
	g_nMax = m.g_nMax + m.nTotal_Views
	Stat_Message()
* Get number of connections contained in database
	nTotal_Connections = ADBOBJECTS(aAll_Connections, "Connection")
	g_nMax = m.g_nMax + m.nTotal_Connections
	Stat_Message()
* Get number of relations contained in database
	nTotal_Relations = ADBOBJECTS(aAll_Relations, "Relation")
	g_nMax = m.g_nMax + m.nTotal_Relations
	Stat_Message()

	CLOSE DATABASE
	SELECT 0
* Check for this database... If it's there, we must have left it
* here because of an error last time.
	IF FILE (FORCEEXT(lcFileName, "DBF"))
		ERASE (FORCEEXT(lcFileName, "DBF"))
		ERASE (FORCEEXT(lcFileName, "FPT"))
	ENDIF
	CREATE TABLE &lcFileName. (PROGRAM M)
	APPEND BLANK
	USE

**************************
*** Get Stored Procedures
**************************
* Create an output file that will be appended to the database
* as procedures
	cFile = UPPER(SUBSTR(m.cOutFile, 1, RAT(".", m.cOutFile))) + "krt"

* Place Header Information For Source/Object
	hFile = FCREATE(m.cFile)
	IF m.hFile <= 0
		FCLOSE(m.hFile)
		FatalAlert(NO_OUTPUT_WRITTEN_LOC, .T.)
	ENDIF

	FPUTS(m.hFile, NO_MODIFY_LOC)
	FCLOSE(m.hFile)
* No we are going to copy the object and source code
* For the stored procedures
	USE (m.g_cFullDatabase) SHARED

	LOCATE FOR Objectname = 'StoredProceduresSource'
	IF FOUND()
		COPY MEMO CODE TO (m.cFile) ADDITIVE
	ENDIF
	ADIR(aTemp, m.cFile)
	nSourceSize = aTemp(1, 2) - LEN(NO_MODIFY_LOC)
*{V&U MS 2009-03-11 Stored procedures do not work without this
	LOCATE FOR Objectname = 'StoredProceduresObject'
	IF FOUND()
		COPY MEMO CODE TO (m.cFile) ADDITIVE
	ENDIF
*}V&U MS 2009-03-11
	USE

* Open the database again
	OPEN DATABASE (m.g_cFullDatabase) SHARED

	ADIR(aTemp, m.cFile)
* Check for actual output file being created sans header
	IF aTemp(1, 2) > LEN(NO_MODIFY_LOC) + 2
**************************
*** Make the output file recreate the procedure file via code.
**************************
		hOutFile =  FCREATE(FORCEEXT(lcFileName, "$$$"))
		IF m.hOutFile <= 0
			 = FCLOSE(m.hFile)
			 = FatalAlert(NO_OUTPUT_WRITTEN_LOC, .T.)
		ENDIF
		WriteFile(m.hOutFile, "")
		WriteFile(m.hOutFile, "********* " + BEGIN_PROC_LOC + " *********")
		WriteFile(m.hOutFile, "IF !FILE([" + SUBSTR(m.cFile, RAT("\", m.cFile) + 1) + "])")
		WriteFile(m.hOutFile, "    ? [" + NO_FILE_FOUND_LOC + "]")
		WriteFile(m.hOutFile, "ELSE")
		WriteFile(m.hOutFile, "	CLOSE DATABASE")
		WriteFile(m.hOutFile, "	USE '" +  m.g_cDatabase + "'")
		WriteFile(m.hOutFile, "	g_SetSafety = SET('SAFETY')")
		WriteFile(m.hOutFile, "	SET SAFETY OFF")
		WriteFile(m.hOutFile, "	LOCATE FOR Objectname = 'StoredProceduresSource'")
		WriteFile(m.hOutFile, "	IF FOUND()")
		*{V&U MS 2010-01-20
		WriteFile(m.hOutFile, "	    REPLACE Code WITH SUBSTR(FILETOSTR([" + SUBSTR(m.cFile, RAT("\", m.cFile) + 1) + "]), " + ;
											ALLTRIM(STR(LEN(NO_MODIFY_LOC) + 3)) + ", " + ALLTRIM(STR(m.nSourceSize - 2)) + ")")
		*}V&U MS 2010-01-20
		WriteFile(m.hOutFile, "	ENDIF")
*{V&U MS 2009-03-11
		WriteFile(m.hOutFile, "	LOCATE FOR Objectname = 'StoredProceduresObject'")
		WriteFile(m.hOutFile, "	IF FOUND()")
		*{V&U MS 2010-01-20
		WriteFile(m.hOutFile, "	    REPLACE Code WITH SUBSTR(FILETOSTR([" + SUBSTR(m.cFile, RAT("\", m.cFile) + 1) + "]), " + ;
											ALLTRIM(STR(LEN(NO_MODIFY_LOC) + m.nSourceSize + 1)) + ")")
		*}V&U MS 2010-01-20
		WriteFile(m.hOutFile, "	ENDIF")
*}V&U MS 2009-03-11
		WriteFile(m.hOutFile, "    SET SAFETY &g_SetSafety")
		WriteFile(m.hOutFile, "	USE")
*{V&U MS 2010-11-16
		WriteFile(m.hOutFile, "	COMPILE DATABASE [" + m.g_cDatabase + "]")
*}V&U MS 2010-11-16
		WriteFile(m.hOutFile, "	OPEN DATABASE [" + m.g_cDatabase + "]")
		WriteFile(m.hOutFile, "ENDIF")
		WriteFile(m.hOutFile, "")
		FCLOSE(m.hOutFile)
		USE (lcFileName) EXCLUSIVE
		APPEND MEMO PROGRAM FROM (FORCEEXT(lcFileName, "$$$"))
		ERASE (FORCEEXT(lcFileName, "$$$"))
		USE
	ELSE
		ERASE (m.cFile)
	ENDIF
	Stat_Message()
* Write out database creation routines
	UpdateProcArray("DisplayStatus([" + MESSAGE_START_LOC +"])")
	UpdateProcArray("CREATE DATABASE '" + m.g_cDatabase + "'")

	LOCAL lcDBCComment, llDBCEvents, lcDBCEventsfile
	lcDBCComment = DBGETPROP(m.g_cDatabase, 'Database', 'Comment')
	llDBCEvents = DBGETPROP(m.g_cDatabase, 'Database', 'DBCEvents')
	lcDBCEventsfile = DBGETPROP(m.g_cDatabase, 'Database', 'DBCEventFileName')
* Add database comment
	IF !EMPTY(lcDBCComment)
		lcDBCComment = STRTRAN(m.lcDBCComment, ["], ['])
		lcDBCComment = STRTRAN(m.lcDBCComment, CHR(10))
		lcDBCComment = STRTRAN(m.lcDBCComment, CHR(13), '" + CHR(13) + "')
		UpdateProcArray("DBSETPROP('" + m.g_cDatabase + "', 'Database', 'Comment', " + '"' + m.lcDBCComment + '")')
	ENDIF

* Add DBCEvents
	IF VARTYPE(llDBCEvents) == "L" AND llDBCEvents
		UpdateProcArray("DBSETPROP('" + m.g_cDatabase + "', 'Database', 'DBCEvents', .T.)")
	ENDIF

* Add DBCEvents file
	IF !EMPTY(lcDBCEventsfile)
		UpdateProcArray("DBSETPROP('" + m.g_cDatabase + "', 'Database', 'DBCEventFileName', '" + m.lcDBCEventsfile + "')")
	ENDIF

**************************
*** Get Tables
**************************
	IF m.nTotal_Tables > 0
		LOCAL lnTableNo
		FOR lnTableNo = 1 TO m.nTotal_Tables
			DO GetTable WITH ALLTRIM(aAll_Tables(lnTableNo)), FORCEEXT(lcFileName, "tmp")	&&"GenDBC.tmp"
			Stat_Message()
			USE (lcFileName) EXCLUSIVE
			APPEND MEMO PROGRAM FROM FORCEEXT(lcFileName, "tmp")
			USE
			ERASE FORCEEXT(lcFileName, "tmp")
			UpdateProcArray("DisplayStatus([" + MESSAGE_MAKETABLE_LOC + aAll_Tables(lnTableNo) + MESSAGE_END_LOC + "])")
			UpdateProcArray("MakeTable_" + FixName(aAll_Tables(lnTableNo)) + "()")
		ENDFOR
	ENDIF

**************************
*** Get Connections
**************************
	IF m.nTotal_Connections > 0
		LOCAL lnConnectionNo
		FOR lnConnectionNo = 1 TO m.nTotal_Connections
			DO GetConn WITH aAll_Connections(lnConnectionNo), FORCEEXT(lcFileName, "tmp")
			Stat_Message()
			USE (lcFileName) EXCLUSIVE
			APPEND MEMO PROGRAM FROM FORCEEXT(lcFileName, "tmp")
			USE
			ERASE FORCEEXT(lcFileName, "tmp")
			UpdateProcArray("DisplayStatus([" + MESSAGE_MAKECONN_LOC + aAll_Connections(lnConnectionNo) + MESSAGE_END_LOC + "])")
			UpdateProcArray("MakeConn_" + FIXNAME(aAll_Connections(lnConnectionNo)) + "()")
		ENDFOR
	ENDIF

**************************
*** Get Views
**************************
* {V&U VM 2013-02-26 modify 
	IF m.nTotal_Views > 0
		LOCAL lnViewNo
		FOR lnViewNo = 1 TO m.nTotal_Views
			DO GetView WITH ALLTRIM(aAll_Views(lnViewNo, 1)), FORCEEXT(lcFileName, "tmp")
			Stat_Message()
			USE (lcFileName) EXCLUSIVE
			APPEND MEMO PROGRAM FROM FORCEEXT(lcFileName, "tmp")
			USE
			ERASE FORCEEXT(lcFileName, "tmp")
			UpdateProcArray("DisplayStatus([" + MESSAGE_MAKEVIEW_LOC + aAll_Views(lnViewNo, 1) + MESSAGE_END_LOC + "])")
			UpdateProcArray("MakeView_" + FIXNAME(aAll_Views(lnViewNo, 1)) + "()")
		ENDFOR
	ENDIF
* }V&U VM 2013-02-26 
**************************
*** Get Relations
**************************
	IF m.nTotal_Relations > 0
		USE (lcFileName) EXCLUSIVE
		REPLACE PROGRAM WITH BEGIN_RELATION_LOC + CRLF ADDITIVE
		UpdateProcArray("DisplayStatus([" + MESSAGE_MAKERELATION_LOC + "])")
		LOCAL lnRelationNo
		FOR lnRelationNo = 1 TO m.nTotal_Relations
			REPLACE PROGRAM WITH CRLF + "FUNCTION MakeRelation_" + TRANS(lnRelationNo) + CRLF + ;
				"ALTER TABLE '" + aAll_Relations(lnRelationNo, 1) + ;
				"' ADD FOREIGN KEY TAG " + ;
				aAll_Relations(lnRelationNo, 3) + ;
				" REFERENCES " + ;
				aAll_Relations(lnRelationNo, 2) + ;
				" TAG " + aAll_Relations(lnRelationNo, 4) + ;
				CRLF + "ENDFUNC" + CRLF + CRLF ADDITIVE
			UpdateProcArray("MakeRelation_" + TRANS(lnRelationNo) + "()")
			Stat_Message()
		ENDFOR
	ENDIF
	CLOSE DATABASE  && Because we're going to start peeking into the
&& table structure of the DBC

**************************
*** Get RI Info
**************************
	IF m.nTotal_Relations > 0
		DO GetRI WITH FORCEEXT(lcFileName, "tmp")
		IF FILE(FORCEEXT(lcFileName, "tmp"))
			USE (lcFileName) EXCLUSIVE
			APPEND MEMO PROGRAM FROM FORCEEXT(lcFileName, "tmp")
			USE
			ERASE FORCEEXT(lcFileName, "tmp")
			UpdateProcArray("DisplayStatus([" + MESSAGE_MAKERI_LOC + "])")
			UpdateProcArray("MakeRI()")
		ENDIF
	ENDIF
	UpdateProcArray("DisplayStatus([" + MESSAGE_DONE_LOC + "])")
	Stat_Message()
*! Make it a permanent file
	USE (lcFileName) EXCLUSIVE
	lcProcStr = ""
	FOR i = 1 TO ALEN(g_aprocs)
		lcprocstr = lcprocstr + g_aprocs[m.i] + CRLF
	ENDFOR
	lcMessageStr =  "FUNCTION DisplayStatus(lcMessage)" + CRLF + ;
		"*WAIT WINDOW NOWAIT lcMessage" + CRLF + ;
		"ENDFUNC"
*{V&U MS 2010-02-03
	lcParameterLine = [lParameters tcLogFileName] + CRLF + CRLF + ;
		[Public _GenDBC_Error, _GenDBC_LogFileName ] + CRLF + ;
		[IF EMPTY(tcLogFileName)] + CRLF + ;
		[	_GenDBC_LogFileName = "CreateEmptyDbc.log"] + CRLF + ;
		[ELSE] + CRLF + ;
		[	_GenDBC_LogFileName = tcLogFileName] + CRLF + ;
		[ENDIF] + CRLF
*}V&U MS 2010-02-03
*{V&U MS 2009-03-02
	REPLACE PROGRAM WITH HEADING_1_LOC + "* * " + DTOC(DATE()) + ;
		SPACE(19 - LEN(m.g_cDatabase) / 2) + ;
		m.g_cDatabase + SPACE(19 - LEN(m.g_cDatabase) / 2) + ;
		TIME() + CRLF + HEADING_2_LOC + CRLF + ;
		IIF(!EMPTY(m.g_cFilterExp), NS_COMMENT_LOC + m.g_cFilterExp + ;
		CRLF + REPLICATE("*", 52) + CRLF, "") + ;
		lcParameterLine + CRLF + CRLF + ;
		lcprocstr + ;
		"RELEASE _GenDBC_LogFileName " + CRLF + CRLF + ;
		PROGRAM + CRLF + ;
		lcMessageStr + CRLF
*}V&U MS 2009-03-02
	COPY MEMO PROGRAM TO (m.cOutFile)
	USE
	ERASE FORCEEXT(lcFileName, "DBF")
	ERASE FORCEEXT(lcFileName, "FPT")

	Stat_Message()
* Exit Program
	COMPILE (m.cOutFile)
	GenDBC_CleanUp(.T.)

CATCH TO loError
	llGenDbcRes = .F.
	IF TYPE("poSyncServer.cLogFile") == "C"
		poSyncServer.WriteLog("Error in vfxGenDBC: ErrorNo = " + TRANSFORM(loError.ERRORNO) + ;
			"; Message: " + TRANSFORM(loError.MESSAGE) + ;
			"; LineNo: " + TRANSFORM(loError.LINENO) + ;
			"; LineContents: " + TRANSFORM(loError.LINECONTENTS))
	ENDIF

	IF FILE(FORCEEXT(lcFileName, "DBF"))
		ERASE FORCEEXT(lcFileName, "DBF")
	ENDIF
	IF FILE(FORCEEXT(lcFileName, "DBF"))
		ERASE FORCEEXT(lcFileName, "FPT")
	ENDIF
ENDTRY

RETURN llGenDbcRes
ENDPROC

PROCEDURE GetRI
LPARAMETERS cOutFileName

* Create the output file
hGTFile = FCREATE(m.cOutFileName)
IF m.hGTFile < 1
	FatalAlert(NO_TEMP_FILE_LOC + m.cOutFileName, .T.)
ENDIF

* USE the database
USE (m.g_cFullDatabase) SHARED

LOCATE FOR ObjectType = "Relation" AND !EMPTY(RiInfo)
IF FOUND()
	WriteFile(m.hGTFile, "FUNCTION MakeRI")
	WriteFile(m.hGTFile, "***** " + BEGIN_RI_LOC + " *****")
	WriteFile(m.hGTFile, "CLOSE DATABASE")
	WriteFile(m.hGTFile, "USE '" +  m.g_cDatabase + "'")
	DO WHILE FOUND()
* Have to get the parent name to verify we are adding
* Information to the right record.
		nParentID = ParentID
* We use select so we won't mess up our LOCATE ... CONTINUE command
		SELECT ObjectName FROM (m.g_cFullDatabase) WHERE ObjectID = nParentID INTO ARRAY aTableName
		nStart = 1
		cITag = ""
		cTable = ""
		cRTag = ""
		DO WHILE m.nStart <= LEN(Property)
			nSize = ASC(SUBSTR(Property, m.nStart, 1)) + ;
				(ASC(SUBSTR(Property, m.nStart + 1, 1)) * 256) + ;
				(ASC(SUBSTR(Property, m.nStart + 2, 1)) * 256^2) + ;
				(ASC(SUBSTR(Property, m.nStart + 3, 1)) * 256^3)

			nKey = ASC(SUBSTR(Property, m.nStart + 6, 1))

			DO CASE
				CASE m.nKey = 13
					cITag = SUBSTR(Property, m.nStart + 7, m.nSize - 8)
				CASE m.nKey = 18
					cTable = SUBSTR(Property, m.nStart + 7, m.nSize - 8)
				CASE m.nKey = 19
					cRTag = SUBSTR(Property, m.nStart + 7, m.nSize - 8)
			ENDCASE
			nStart = m.nStart + m.nSize
		ENDDO
		WriteFile(m.hGTFile, "LOCATE FOR ObjectType = 'Table' AND ObjectName = '" + ;
			ALLTRIM(aTableName(1)) + "'")
		WriteFile(m.hGTFile, "IF FOUND()")
		WriteFile(m.hGTFile, "    nObjectID = ObjectID")
		WriteFile(m.hGTFile, "    LOCATE FOR ObjectType = 'Relation' AND '" + m.cITag + ;
			"'$Property AND '" + m.cTable + "'$Property AND '" + m.cRTag + ;
			"'$Property AND ParentID = nObjectID")
		WriteFile(m.hGTFile, "    IF FOUND()")
		WriteFile(m.hGTFile, "	      REPLACE RiInfo WITH '" + RiInfo + "'")
		WriteFile(m.hGTFile, "    ELSE")
		WriteFile(m.hGTFile, '       ? "' + NO_FIND_LOC + '"')
		WriteFile(m.hGTFile, "    ENDIF")
		WriteFile(m.hGTFile, "ENDIF")
		CONTINUE
	ENDDO
	WriteFile(m.hGTFile, "USE")
	WriteFile(m.hGTFile, "ENDFUNC")
	WriteFile(m.hGTFile, "")
	FCLOSE(m.hGTFile)
ELSE
	FCLOSE(m.hGTFile)
	ERASE (m.cOutFileName)
ENDIF
USE
RETURN

PROCEDURE GetTable
LPARAMETERS cTableName, cOutFileName

* Create the output file
hGTFile = FCREATE(m.cOutFileName)
IF m.hGTFile < 1
	FatalAlert(NO_TEMP_FILE_LOC + m.cOutFileName, .T.)
ENDIF

* Open Table to get field info
USE (m.cTableName) SHARED

* Get all the fields
nNumberOfFields = AFIELDS(aAll_Fields)

* Header Information
WriteFile(m.hGTFile, "FUNCTION MakeTable_" + FIXNAME(m.cTableName))
*{V&U MS 2009-02-25
WriteFile(m.hGTFile, "TRY ")
*}V&U MS 2009-02-25
WriteFile(m.hGTFile, "***** " + BEGIN_TABLE_LOC + m.cTableName + " *****")

* If the table is greater than 8 characters then it will fail on platforms that
* do not support this (Such as Win32s).
cOldSetFullPath = SET("FULLPATH")
SET FULLPATH OFF
cTableFileName = DBF(ALIAS())
SET FULLPATH &cOldSetFullPath
cTableFileName = SUBSTR(m.cTableFileName, RAT(":", m.cTableFileName) + 1)
cCreateTable = "CREATE TABLE '" + m.cTableFileName + "' NAME '" + m.cTableName + "' ("

*! Information about each field that can been written with CREATE TABLE - SQL
FOR m.nInner_Loop = 1 TO m.nNumberOfFields
	IF m.nInner_Loop = 1
		cCreateTable = m.cCreateTable + aAll_Fields(m.nInner_Loop, 1) + " "
	ELSE
		cCreateTable = SPACE(LEN(m.cTableName) + 15) + ;
			aAll_Fields(m.nInner_Loop, 1) + " "
	ENDIF
	m.cCreateTable = m.cCreateTable + aAll_Fields(m.nInner_Loop, 2)
	DO CASE
		CASE aAll_Fields(m.nInner_Loop, 2) == "C" OR ;
				aAll_Fields(m.nInner_Loop, 2) == "V"
			cCreateTable = m.cCreateTable + "(" + ;
				ALLTRIM(STR(aAll_Fields(m.nInner_Loop, 3))) + ")"
			IF aAll_Fields(m.nInner_Loop, 6)
				cCreateTable = m.cCreateTable + " NOCPTRANS"
			ENDIF
		CASE aAll_Fields(m.nInner_Loop, 2) == "Q"
			cCreateTable = m.cCreateTable + "(" + ;
				ALLTRIM(STR(aAll_Fields(m.nInner_Loop, 3))) + ")"
		CASE aAll_Fields(m.nInner_Loop, 2) == "M"
			IF aAll_Fields(m.nInner_Loop, 6)
				cCreateTable = m.cCreateTable + " NOCPTRANS"
			ENDIF
		CASE aAll_Fields(m.nInner_Loop, 2) == "N" OR ;
				aAll_Fields(m.nInner_Loop, 2) == "F"
			cCreateTable = m.cCreateTable + "(" + ;
				ALLTRIM(STR(aAll_Fields(m.nInner_Loop, 3))) + ;
				", " + ALLTRIM(STR(aAll_Fields(m.nInner_Loop, 4))) + ")"
		CASE aAll_Fields(m.nInner_Loop, 2) == "B"
			cCreateTable = m.cCreateTable + "(" + ;
				ALLTRIM(STR(aAll_Fields(m.nInner_Loop, 4))) ;
				 + ")"
	ENDCASE

	IF aAll_Fields(m.nInner_Loop, 5)
		cCreateTable = m.cCreateTable + " NULL"
	ELSE
		cCreateTable = m.cCreateTable + " NOT NULL"
	ENDIF

	IF aAll_Fields(m.nInner_Loop, 18) <> 0
		cCreateTable = m.cCreateTable + " AUTOINC NEXTVALUE " + ;
			ALLTRIM(STR(aAll_Fields[m.nInner_Loop, 17])) + ;
			" STEP " + ALLTRIM(STR(aAll_Fields[m.nInner_Loop, 18]))
	ENDIF

* Get properties for fields
	IF !EMPTY(aAll_Fields(m.nInner_Loop, 7))
		cCreateTable = m.cCreateTable + " CHECK " + aAll_Fields(m.nInner_Loop, 7)
	ENDIF

	IF !EMPTY(aAll_Fields(m.nInner_Loop, 8))
		cCreateTable = m.cCreateTable + " ERROR " + aAll_Fields(m.nInner_Loop, 8)
	ENDIF

	IF !EMPTY(aAll_Fields(m.nInner_Loop, 9))
		cCreateTable = m.cCreateTable + " DEFAULT " + aAll_Fields(m.nInner_Loop, 9)
	ENDIF

	IF m.nInner_Loop <> m.nNumberOfFields
		cCreateTable = m.cCreateTable + ", ;"
	ELSE
		cCreateTable = m.cCreateTable + ")"
	ENDIF

	WriteFile(m.hGTFile, m.cCreateTable)
ENDFOR

* Get Index Information
WriteFile(m.hGTFile, CRLF + "***** " + BEGIN_INDEX_LOC + m.cTableName + " *****")
cCollate = ""

ATAGINFO(laTags)
FOR m.nInner_Loop = 1 TO TAGCOUNT()
	cTag = UPPER(ALLTRIM(TAG(m.nInner_Loop)))
	cCollate = IDXCOLLATE(m.nInner_Loop)
	IF !EMPTY(m.cTag)
		lnIndex  = ASCAN(laTags, m.cTag, -1, -1, 1, 15)
		llBinary = IIF(m.lnIndex > 0, laTags[lnIndex, 2] = "BINARY", .F.)
		DO CASE
			CASE PRIMARY(m.nInner_Loop)
				IF EMPTY(SYS(2021, m.nInner_Loop))
					WriteFile(m.hGTFile, "ALTER TABLE '" + m.cTableName + ;
						"' ADD PRIMARY KEY " + SYS(14, m.nInner_Loop) + ;
						" TAG " + m.cTag + " COLLATE '" + m.cCollate + "'")
				ELSE
					WriteFile(m.hGTFile, "ALTER TABLE '" + m.cTableName + ;
						"' ADD PRIMARY KEY " + SYS(14, m.nInner_Loop) + ;
						" FOR " + SYS(2021, m.nInner_Loop) + ;
						" TAG " + m.cTag + ;
						" COLLATE '" + m.cCollate + "'")
				ENDIF
			CASE CANDIDATE(m.nInner_Loop)
				IF EMPTY(SYS(2021, m.nInner_Loop))
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop) + ;
						" TAG " + m.cTag + " CANDIDATE COLLATE '" + ;
						m.cCollate + "'")
				ELSE
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop) + ;
						" TAG " + m.cTag + " FOR " + SYS(2021, m.nInner_Loop) + ;
						 + " CANDIDATE COLLATE '" + m.cCollate + "'")
				ENDIF
			CASE UNIQUE(m.nInner_Loop)
				IF(EMPTY(SYS(2021, m.nInner_Loop)))
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop) + ;
						" TAG " + m.cTag + " UNIQUE COLLATE '" + m.cCollate + "'")
				ELSE
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop);
						 + " TAG " + m.cTag + " FOR " + SYS(2021, m.nInner_Loop) ;
						 + " UNIQUE COLLATE '" + m.cCollate + "'")
				ENDIF
			CASE llBinary
				WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop) + ;
					" TAG " + m.cTag + " BINARY")
			OTHERWISE
				IF(EMPTY(SYS(2021, m.nInner_Loop)))
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop) + ;
						" TAG " + m.cTag + ;
						IIF(DESCENDING(m.nInner_Loop), " DESCENDING ", "") + ;
						" COLLATE '" + m.cCollate + "'")
				ELSE
					WriteFile(m.hGTFile, "INDEX ON " + SYS(14, m.nInner_Loop);
						 + " TAG " + m.cTag + " FOR " + SYS(2021, m.nInner_Loop) + ;
						IIF(DESCENDING(m.nInner_Loop), " DESCENDING ", "") + ;
						" COLLATE '" + m.cCollate + "'")
				ENDIF
		ENDCASE
	ELSE
		EXIT FOR
	ENDIF
ENDFOR

* Get Properties For Table
WriteFile(hGTFile, CRLF + "***** " + BEGIN_PROP_LOC + m.cTableName + " *****")
FOR m.nInner_Loop = 1 TO m.nNumberOfFields
	cFieldAlias = m.cTableName + "." + aAll_Fields(m.nInner_Loop, 1)
	cFieldHeaderAlias = [DBSETPROP('] + m.cFieldAlias + [', 'Field', ]
	cTemp = DBGETPROP(m.cFieldAlias, "Field", "Caption")
	IF !EMPTY(cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
		WriteFile(hGTFile, m.cFieldHeaderAlias + ['Caption', "] + m.cTemp + [")])
	ENDIF
	cTemp = DBGETPROP(m.cFieldAlias, "Field", "Comment")
	IF !EMPTY(m.cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
* Strip Line Feeds
		cTemp = STRTRAN(m.cTemp, CHR(10))
* Convert Carriage Returns To Programmatic Carriage Returns
		cTemp = STRTRAN(m.cTemp, CHR(13), '" + CHR(13) + "')
		WriteFile(m.hGTFile, m.cFieldHeaderAlias + ['Comment', "] + m.cTemp + [")])
	ENDIF
	cTemp = DBGETPROP(m.cFieldAlias, "Field", "InputMask")
	IF !EMPTY(m.cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
		WriteFile(m.hGTFile, m.cFieldHeaderAlias + ['InputMask', "] + m.cTemp + [")])
	ENDIF
	cTemp = DBGETPROP(m.cFieldAlias, "Field", "Format")
	IF !EMPTY(m.cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
		WriteFile(m.hGTFile, m.cFieldHeaderAlias + ['Format', "] + m.cTemp + [")])
	ENDIF

	cTemp = DBGETPROP(m.cFieldAlias, "Field", "DisplayClass")
	IF !EMPTY(m.cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
		WriteFile(m.hGTFile, m.cFieldHeaderAlias + ['DisplayClass', "] + m.cTemp + [")])
	ENDIF

	cTemp = DBGETPROP(m.cFieldAlias, "Field", "DisplayClassLibrary")
	IF !EMPTY(m.cTemp)
		cTemp = STRTRAN(m.cTemp, ["], ['])
		WriteFile(m.hGTFile, m.cFieldHeaderAlias + ['DisplayClassLibrary', "] + m.cTemp + [")])
	ENDIF
ENDFOR

cTemp = DBGETPROP(m.cTableName, "Table", "Comment")
IF !EMPTY(m.cTemp)
	cTemp = STRTRAN(m.cTemp, ["], ['])
* Strip Line Feeds
	cTemp = STRTRAN(m.cTemp, CHR(10))
* Convert Carriage Returns To Programmatic Carriage Returns
	cTemp = STRTRAN(m.cTemp, CHR(13), '" + CHR(13) + "')
	WriteFile(m.hGTFile, [DBSETPROP('] + m.cTableName + [', 'Table', ] + ['Comment', "] + m.cTemp + [")])
ENDIF

cTemp = DBGETPROP(m.cTableName, "Table", "DeleteTrigger")
IF !EMPTY(m.cTemp)
	WriteFile(hGTFile, "CREATE TRIGGER ON '" + m.cTableName + ;
		"' FOR DELETE AS " + m.cTemp)
ENDIF

cTemp = DBGETPROP(m.cTableName, "Table", "InsertTrigger")
IF !EMPTY(m.cTemp)
	WriteFile(m.hGTFile, "CREATE TRIGGER ON '" + m.cTableName + ;
		"' FOR INSERT AS " + m.cTemp)
ENDIF

cTemp = DBGETPROP(m.cTableName, "Table", "UpdateTrigger")
IF !EMPTY(m.cTemp)
	WriteFile(m.hGTFile, "CREATE TRIGGER ON '" + m.cTableName + ;
		"' FOR UPDATE AS " + m.cTemp)
ENDIF

cTemp = DBGETPROP(m.cTableName, "Table", "RuleExpression")
IF !EMPTY(m.cTemp)
	cError = DBGETPROP(m.cTableName, "Table", "RuleText")
	IF !EMPTY(cError)
		WriteFile(m.hGTFile, "ALTER TABLE '" + m.cTableName + ;
			"' SET CHECK " + m.cTemp + " ERROR " + ;
			m.cError)
	ELSE
		WriteFile(m.hGTFile, "ALTER TABLE '" + m.cTableName + ;
			"' SET CHECK " + m.cTemp)
	ENDIF
ENDIF

*{V&U MS 2009-02-25
lcEndTryBlock = [	STRTOFILE("Table ' ] + cTableFileName + [' was created!" + CHR(13) + CHR(10), _GenDBC_LogFileName, 1)] + CRLF + ;
	[CATCH TO loError] + CRLF + ;
	[	_GenDBC_Error = .T.] + CRLF + ;
	[	STRTOFILE("***Error while creating ' ] + cTableFileName + ;
	[', Error: " + loError.Message + CHR(13) + CHR(10), _GenDBC_LogFileName, 1)] + CRLF + ;
	[ENDTRY] + CRLF

WriteFile(m.hGTFile, lcEndTryBlock)
*}V&U MS 2009-02-25

WriteFile(m.hGTFile, "ENDFUNC")
WriteFile(m.hGTFile, "")
FCLOSE(m.hGTFile)
RETURN

PROCEDURE GetView

LPARAMETERS cViewName, cOutFileName

nFileHand = FCREATE(m.cOutFileName, 0)
IF m.nFileHand < 1
	FatalAlert(NO_TEMP_FILE_LOC + m.cOutFileName, .T.)
ENDIF

* Get View Information for later use
nSourceType = DBGETPROP(m.cViewName, 'View', 'SourceType')
cConnectName = ALLTRIM(DBGETPROP(m.cViewName, 'View', 'ConnectName'))
cSQL = ALLTRIM(DBGETPROP(m.cViewName, 'View', 'SQL'))
cnUpdateType = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'UpdateType')))
cnWhereType = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'WhereType')))
clFetchMemo = IIF(DBGETPROP(m.cViewName, 'View', 'Fetchmemo'),'.T.','.F.')
clShareConnection = IIF(DBGETPROP(m.cViewName, 'View', 'ShareConnection'),'.T.','.F.')
clSendUpdates = IIF(DBGETPROP(m.cViewName, 'View', 'SendUpdates'),'.T.','.F.')
cnUseMemoSize = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'UseMemoSize')))
cnFetchSize = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'FetchSize')))
cnMaxRecords = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'MaxRecords')))
ccTables = ALLTRIM(DBGETPROP(m.cViewName, 'View', 'Tables'))
clPrepared = IIF(!EMPTY(DBGETPROP(m.cViewName, 'View', 'Prepared')), '.T.', '.F.')
clCompareMemo = IIF(!EMPTY(DBGETPROP(m.cViewName, 'View', 'CompareMemo')), '.T.', '.F.')
clFetchAsNeeded = IIF(!EMPTY(DBGETPROP(m.cViewName, 'View', 'FetchAsNeeded')), '.T.', '.F.')
cParams = ALLTRIM(DBGETPROP(m.cViewName, 'View', 'ParameterList'))
lOffline = DBGETPROP(m.cViewName, 'View', 'Offline')
clAllowSimultaneousFetch = IIF(!EMPTY(DBGETPROP(m.cViewName, 'View', 'AllowSimultaneousFetch')), '.T.', '.F.')
cComment = DBGETPROP(m.cViewName, 'View', 'Comment')
IF !EMPTY(m.cComment)
	cComment = STRTRAN(m.cComment, ["], ['])
* Strip Line Feeds
	cComment = STRTRAN(m.cComment, CHR(10))
* Convert Carriage Returns To Programmatic Carriage Returns
	cComment = STRTRAN(m.cComment, CHR(13), '" + CHR(13) + "')
ENDIF
cnBatchUpdateCount = ALLTRIM(STR(DBGETPROP(m.cViewName, 'View', 'BatchUpdateCount')))

* Generate Comment Block
WriteFile(m.nFileHand, "FUNCTION MakeView_" + FIXNAME(m.cViewName))

cCommentBlock = "***************** " + BEGIN_VIEW_LOC + m.cViewName + ;
	" ***************" + CRLF

WriteFile(m.nFileHand, m.cCommentBlock)

* Generate CREATE VIEW command
cCreateString = 'CREATE SQL VIEW "' + ALLTRIM(m.cViewName) +'" ; ' + CRLF

IF m.nSourceType != 1     && If it isn't a local view
	cCreateString = m.cCreateString + '   REMOTE '
	IF !EMPTY(m.cConnectName)
		cCreateString = m.cCreateString + 'CONNECT "' + m.cConnectName + '" ; ' + CRLF
	ENDIF
ENDIF
cCreateString = m.cCreateString + '   AS ' + m.cSQL + CRLF

WriteFile(m.nFileHand, m.cCreateString)

* GENERATE code to Set View Level Properties
cViewDBSetPrefix = [DBSetProp('] + m.cViewName +[', 'View', ]

WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['UpdateType', ] + m.cnUpdateType + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['WhereType', ] + m.cnWhereType + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['FetchMemo', ] + m.clFetchMemo + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['SendUpdates', ] + m.clSendUpdates + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['UseMemoSize', ] + m.cnUseMemoSize + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['FetchSize', ] + m.cnFetchSize + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['MaxRecords', ] + m.cnMaxRecords + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['Tables', '] + m.ccTables + [')])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['Prepared', ] + m.clPrepared + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['CompareMemo', ] + m.clCompareMemo + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['FetchAsNeeded', ] + m.clFetchAsNeeded + [)])
IF !EMPTY(m.cParams)
	WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['ParameterList', "] + m.cParams + [")])
ENDIF
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['Comment', "] +  m.cComment + [")])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['BatchUpdateCount', ] + m.cnBatchUpdateCount + [)])
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['ShareConnection', ] + m.clShareConnection + [)])
IF m.lOffline
	WriteFile(m.nFileHand, 'CREATEOFFLINE("' + m.cViewName + '")')
ENDIF
WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['AllowSimultaneousFetch', ] + m.clAllowSimultaneousFetch + [)])
cRuleExpression = DBGETPROP(m.cViewName, "View", "RuleExpression")
IF !EMPTY(m.cRuleExpression)
	WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['RuleExpression', '] + m.cRuleExpression + [')])
ENDIF
cRuleText = DBGETPROP(m.cViewName, "View", "RuleText")
IF !EMPTY(m.cRuleExpression)
	WriteFile(m.nFileHand, m.cViewDBSetPrefix + ['RuleText', '] + m.cRuleText + [')])
ENDIF

* GENERATE code to Set Field Level Properties
USE (DBC()) AGAIN IN 0 ALIAS GenViewCursor SHARED

SELECT GenViewCursor
LOCATE FOR ALLTRIM(UPPER(GenViewCursor.ObjectName)) == m.cViewName AND ;
	GenViewCursor.ObjectType = 'View'
nObjectId = GenViewCursor.ObjectId
SELECT ObjectName FROM GenViewCursor ;
	WHERE GenViewCursor.ParentId = m.nObjectId ;
	INTO ARRAY aViewFields
USE IN GenViewCursor
WriteFile(m.nFileHand, CRLF + '*!* Field Level Properties for ' + m.cViewName)

IF _TALLY # 0
	FOR m.nLoop = 1 TO ALEN(aViewFields, 1)
		cFieldAlias = m.cViewName + "." + ALLTRIM(aViewFields(nLoop, 1))
		clKeyField = IIF(DBGETPROP(m.cFieldAlias, 'Field', 'KeyField'),'.T.','.F.')
		clUpdatable = IIF(DBGETPROP(m.cFieldAlias, 'Field', 'Updatable'),'.T.','.F.')
		ccUpdateName = ALLTRIM(DBGETPROP(m.cFieldAlias, 'Field', 'UpdateName'))
		cViewFieldSetPrefix = [DBSetProp('] + m.cFieldAlias +[', 'Field', ]

		WriteFile(m.nFileHand, '* Props for the ' + m.cFieldAlias +' field.')
		WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['KeyField', ] + m.clKeyField + [)])
		WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['Updatable', ] + m.clUpdatable + [)])
		lcDelimiter = IIF(['] $ m.ccUpdateName, ["], ['])
		WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['UpdateName', ] + ;
			lcDelimiter + m.ccUpdateName + m.lcDelimiter + [)])
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "RuleExpression")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['RuleExpression', "] + m.cTemp +[")])
		ENDIF

		cTemp = DBGETPROP(m.cFieldAlias, "Field", "RuleText")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['RuleText', "] + m.cTemp +[")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "Caption")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['Caption', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "Comment")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
* Strip Line Feeds
			cTemp = STRTRAN(m.cTemp, CHR(10))
* Convert Carriage Returns To Programmatic Carriage Returns
			cTemp = STRTRAN(m.cTemp, CHR(13), '" + CHR(13) + "')
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['Comment', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "InputMask")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['InputMask', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "Format")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['Format', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "DisplayClass")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['DisplayClass', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "DisplayClassLibrary")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['DisplayClassLibrary', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "DataType")
		IF !EMPTY(m.cTemp)
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['DataType', "] + m.cTemp + [")])
		ENDIF
		cTemp = DBGETPROP(m.cFieldAlias, "Field", "DefaultValue")
		IF !EMPTY(m.cTemp)
			cTemp = STRTRAN(m.cTemp, ["], ['])
			WriteFile(m.nFileHand, m.cViewFieldSetPrefix + ['DefaultValue', "] + m.cTemp + [")])
		ENDIF
	ENDFOR
ENDIF

WriteFile(m.nFileHand, "ENDFUNC")
WriteFile(m.nFileHand, " ")

*! Close output file
FCLOSE(m.nFileHand)

RETURN

PROCEDURE GetConn
LPARAMETERS cConnectionName, m.cOutFileName

nFileHand = FCREATE(m.cOutFileName, 0)
IF m.nFileHand < 1
	FatalAlert(NO_TEMP_FILE_LOC + m.cOutFileName, .T.)
ENDIF

* Get Connection Information for later use
clAsynchronous = IIF(DBGETPROP(m.cConnectionName, 'Connection', 'Asynchronous'),'.T.','.F.')
clBatchMode = IIF(DBGETPROP(m.cConnectionName, 'Connection', 'BatchMode'),'.T.','.F.')
ccComment = ALLTRIM(DBGETPROP(m.cConnectionName, 'Connection', 'Comment'))
ccConnectString = ALLTRIM(DBGETPROP(m.cConnectionName, 'Connection', 'ConnectString'))
cnConnectTimeOut = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'ConnectTimeOut')))
ccDataSource = ALLTRIM(DBGETPROP(m.cConnectionName, 'Connection', 'DataSource'))
cnDispLogin = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'DispLogin')))
clDispWarnings = IIF(DBGETPROP(m.cConnectionName, 'Connection', 'DispWarnings'),'.T.','.F.')
cnIdleTimeOut = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'IdleTimeOut')))
ccPassword = ALLTRIM(DBGETPROP(m.cConnectionName, 'Connection', 'Password'))
cnQueryTimeOut = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'QueryTimeOut')))
cnTransactions = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'Transactions')))
ccUserId = ALLTRIM(DBGETPROP(m.cConnectionName, 'Connection', 'UserId'))
cnWaitTime = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'WaitTime')))
ccDatabase = DBGETPROP(m.cConnectionName, 'Connection', 'Database')
cnPacketSize = ALLTRIM(STR(DBGETPROP(m.cConnectionName, 'Connection', 'PacketSize')))

* Generate Comment Block
cCommentBlock = "***************** " + BEGIN_CONNECTIONS_LOC + " " + m.cConnectionName + ;
	" ***************" + CRLF

WriteFile(m.nFileHand, "FUNCTION MakeConn_" + FIXNAME(m.cConnectionName))
WriteFile(m.nFileHand, m.cCommentBlock)

* Generate CREATE Connection command
cCreateString = 'CREATE CONNECTION ' + ALLTRIM(m.cConnectionName) +' ; ' + CRLF

IF EMPTY(ALLTRIM(m.ccConnectString))  && If connectstring not specified
	cCreateString = m.cCreateString + '   DATASOURCE "' + ALLT(m.ccDataSource) + '" ; ' + CRLF
	cCreateString = m.cCreateString + '   USERID "' + ALLT(m.ccUserId) + '" ; ' + CRLF
	cCreateString = m.cCreateString + '   PASSWORD "' + ALLT(m.ccPassword) + '"' + CRLF
ELSE
	cCreateString = m.cCreateString + '   CONNSTRING "' + ALLT(m.ccConnectString) + '"'
ENDIF

WriteFile(m.nFileHand, m.cCreateString)

* GENERATE code to Set Connection Level Properties
cConnectionDBSetPrefix = [DBSetProp('] + m.cConnectionName +[', 'Connection', ]

cConnectionProps = '****' + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['Asynchronous', ] + m.clAsynchronous + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['BatchMode', ] + m.clBatchMode + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['Comment', '] + m.ccComment + [')] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['DispLogin', ] + m.cnDispLogin + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['ConnectTimeOut', ] + m.cnConnectTimeOut + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['DispWarnings', ] + m.clDispWarnings + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['IdleTimeOut', ] + m.cnIdleTimeOut + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['QueryTimeOut', ] + m.cnQueryTimeOut + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['Transactions', ] + m.cnTransactions + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['Database', '] + m.ccDatabase + [')] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['PacketSize', ] + m.cnPacketSize + [)] + CRLF
cConnectionProps = m.cConnectionProps + m.cConnectionDBSetPrefix + ;
	['WaitTime', ] + m.cnWaitTime + [)] + CRLF

WriteFile(m.nFileHand, m.cConnectionProps)
* Close output file
WriteFile(m.nFileHand, "ENDFUNC")
WriteFile(m.nFileHand, " ")

FCLOSE(m.nFileHand)
RETURN

PROCEDURE FatalAlert
LPARAMETERS cAlert_Message, lCleanup
***	MESSAGEBOX(m.cAlert_Message, 16, ERROR_TITLE_LOC)
GenDBC_CleanUp(m.lCleanup)

CANCEL
RETURN

PROCEDURE GenDBC_CleanUp
LPARAMETERS lCleanup

* Restore everything
IF !EMPTY(m.g_cSetTalk)
	SET TALK &g_cSetTalk
ENDIF

IF !EMPTY(m.g_cSetDeleted)
	SET DELETED &g_cSetDeleted
ENDIF

IF m.g_cSetStatusBar = "OFF"
	SET STATUS BAR OFF
ENDIF

IF !EMPTY(m.g_cStatusText)
	SET MESSAGE TO (m.g_cStatusText)
ELSE
	SET MESSAGE TO
ENDIF

IF m.g_cCompat = "ON"
	SET COMPATIBLE ON
ENDIF

SET FULLPATH &g_cFullPath
RETURN

PROCEDURE WriteFile
LPARAMETERS hFileHandle, cText

nBytesSent = FPUTS(m.hFileHandle, m.cText)
IF m.nBytesSent < LEN(m.cText)
	FatalAlert(NO_OUTPUT_WRITTEN_LOC, .T.)
ENDIF
RETURN

PROCEDURE Stat_Message
nStat = m.g_nCurrentStat * (160 / g_nMax)
SET MESSAGE TO REPLICATE("|", m.nStat) + " " + ;
	ALLTRIM(STR(INT(100 * (m.g_nCurrentStat / m.g_nMax)))) + "%"
g_nCurrentStat = m.g_nCurrentStat + 1
RETURN

PROCEDURE UpdateProcArray(lcProcName)
IF g_lskipdisplay AND ATC("DisplayStatus", lcProcName) # 0
	RETURN
ENDIF
IF !EMPTY(g_aprocs[ALEN(g_aprocs)])
	DIMENSION g_aprocs[ALEN(g_aprocs)+1]
ENDIF
g_aprocs[ALEN(g_aprocs)] = lcProcName
ENDPROC

PROCEDURE FixName(lcProcName)
lcProcName = ALLTRIM(lcProcName)
IF VERSION(3) $ DBCS_LOC
	cBadChars = '/,-=:;!@#$%&*.<>()?[]\' + ;
		'+' + CHR(34) + CHR(39) + " "
ELSE
	*{V&U MS 2010-09-30, Replace
		*cBadChars = '/\,-=:;{}[]!@#$%^&*.<>()?' + ;
		*			 '+|' + ;
		*			 '' + CHR(34) + CHR(39) + " "
	cBadChars = CHR(129) + CHR(130) + CHR(131) + CHR(132) + CHR(133) + CHR(134) + ;
				CHR(135) + CHR(136) + CHR(137) + CHR(138) + CHR(139) + CHR(140) + ;
				CHR(142) + CHR(143) + CHR(144) + CHR(145) + CHR(146) + CHR(147) + ;
				CHR(148) + CHR(149) + CHR(150) + CHR(151) + CHR(152) + CHR(153) + ;
				CHR(154) + CHR(160) + CHR(161) + CHR(162) + CHR(163) + CHR(164) + ;
				CHR(165) + CHR(47) + CHR(92) + CHR(44) + CHR(45) + CHR(61) + CHR(58) + ;
				CHR(59) + CHR(123) + CHR(125) + CHR(91) + CHR(93) + CHR(33) + CHR(64) + ;
				CHR(35) + CHR(36) + CHR(37) + CHR(94) + CHR(38) + CHR(42) + CHR(46) + ;
				CHR(60) + CHR(62) + CHR(40) + CHR(41) + CHR(63) + CHR(43) + CHR(124) + ;
				CHR(128) + CHR(155) + CHR(156) + CHR(157) + CHR(158) + CHR(159) + CHR(166) + ;
				CHR(167) + CHR(168) + CHR(169) + CHR(170) + CHR(171) + CHR(172) + CHR(173) + ;
				CHR(174) + CHR(175) + CHR(176) + CHR(177) + CHR(178) + CHR(179) + CHR(180) + ;
				CHR(181) + CHR(182) + CHR(183) + CHR(184) + CHR(185) + CHR(186) + CHR(187) + ;
				CHR(188) + CHR(189) + CHR(190) + CHR(191) + CHR(192) + CHR(193) + CHR(194) + ;
				CHR(195) + CHR(196) + CHR(197) + CHR(198) + CHR(199) + CHR(200) + CHR(201) + ;
				CHR(202) + CHR(203) + CHR(204) + CHR(205) + CHR(206) + CHR(207) + CHR(208) + ;
				CHR(209) + CHR(210) + CHR(211) + CHR(212) + CHR(213) + CHR(214) + CHR(215) + ;
				CHR(216) + CHR(217) + CHR(218) + CHR(219) + CHR(220) + CHR(221) + CHR(222) + ;
				CHR(223) + CHR(224) + CHR(225) + CHR(226) + CHR(227) + CHR(228) + CHR(229) + ;
				CHR(230) + CHR(231) + CHR(232) + CHR(233) + CHR(234) + CHR(235) + CHR(236) + ;
				CHR(237) + CHR(238) + CHR(239) + CHR(240) + CHR(241) + CHR(242) + CHR(243) + ;
				CHR(244) + CHR(245) + CHR(246) + CHR(247) + CHR(248) + CHR(249) + CHR(250) + ;
				CHR(251) + CHR(252) + CHR(253) + CHR(254) + CHR(34) + CHR(39) + " "
	*}V&U MS 2010-09-30			
ENDIF
lcProcName = CHRTRAN(lcProcName, cBadChars, REPL('_', LEN(cBadChars)))
RETURN lcProcName
ENDPROC