LPARAMETERS tcPath
LOCAL llRet, lcDatabaseDir

_screen.Caption = "Repair DBC"

IF VERSION(2) = 2
	MESSAGEBOX("This app should not be executed in IDE! Please create and run an exe file.", 16, _Screen.Caption)
	RETURN 
ENDIF 	

IF PCOUNT() == 0
	* If no parameters are passed, open a select dialog to select a dbc
	lcDatabaseDir = GETDIR(CURDIR(), "of database to repair")
	IF EMPTY(lcDatabaseDir)
		RETURN 
	ENDIF 
	tcPath = JUSTPATH(lcDatabaseDir)
ENDIF 
 
IF !(TYPE("tcPath") == "C" AND DIRECTORY(tcPath))

	MESSAGEBOX("Please pass a valid path.", 16, _Screen.Caption)
	RETURN 				
ENDIF 

SET EXCLUSIVE OFF
SET DELETED ON 
SET TALK OFF
SET SAFETY OFF 
SET MULTILOCKS ON 

SET PROCEDURE TO Program\RepairDBCFunc, Program\GetDbcName ADDITIVE
llRet = RepairDatabase(tcPath)
CLOSE ALL

IF llRet
	MESSAGEBOX("Database was repaired successfully.", 48, _Screen.Caption, 20000)
ENDIF
